// JavaScript voor de moderne template website

// Hamburger menu functionaliteit
const hamburger = document.querySelector('.hamburger');
const navMenu = document.querySelector('.nav-menu');

hamburger.addEventListener('click', () => {
    hamburger.classList.toggle('active');
    navMenu.classList.toggle('active');
});

// Sluit menu wanneer er op een link wordt geklikt
document.querySelectorAll('.nav-menu a').forEach(link => {
    link.addEventListener('click', () => {
        hamburger.classList.remove('active');
        navMenu.classList.remove('active');
    });
});

// Smooth scrolling voor anchor links
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Contact formulier handling
const contactForm = document.getElementById('contactForm');

contactForm.addEventListener('submit', function(e) {
    e.preventDefault();

    const naam = document.getElementById('naam').value;
    const email = document.getElementById('email').value;
    const bericht = document.getElementById('bericht').value;

    // Simpele validatie
    if (naam.trim() === '' || email.trim() === '' || bericht.trim() === '') {
        alert('Vul alstublieft alle velden in.');
        return;
    }

    // Hier zou normaal gesproken de data naar een server gestuurd worden
    // Voor deze demo tonen we een alert
    alert(`Bedankt voor uw bericht, ${naam}! We nemen zo snel mogelijk contact met u op.`);

    // Reset formulier
    contactForm.reset();
});

// Scroll animaties (eenvoudige versie)
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.classList.add('animate');
        }
    });
}, observerOptions);

// Voeg animatie klassen toe aan secties
document.querySelectorAll('section').forEach(section => {
    observer.observe(section);
});

// Portfolio item hover effecten
document.querySelectorAll('.portfolio-item').forEach(item => {
    item.addEventListener('mouseenter', function() {
        this.style.transform = 'scale(1.05)';
    });

    item.addEventListener('mouseleave', function() {
        this.style.transform = 'scale(1)';
    });
});

// Service item hover effecten
document.querySelectorAll('.service-item').forEach(item => {
    item.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-10px)';
    });

    item.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0)';
    });
});
